
<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Sender Branch - Staff'); ?></th>
                                <th><?php echo app('translator')->get('Receiver Branch - Staff'); ?></th>
                                <th><?php echo app('translator')->get('Amount - Order Number'); ?></th>
                                <th><?php echo app('translator')->get('Creations Date'); ?></th>
                                <th><?php echo app('translator')->get('Payment Status'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $courierLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courierInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Sender Branch'); ?>">
                                    <span><?php echo e(__($courierInfo->senderBranch->name)); ?></span><br>
                                    <?php echo e(__($courierInfo->senderStaff->fullname)); ?>

                                </td>

                                <td data-label="<?php echo app('translator')->get('Receiver Branch - Staff'); ?>">
                                    <span>
                                        <?php if($courierInfo->receiver_branch_id): ?>
                                            <?php echo e(__($courierInfo->receiverBranch->name)); ?>

                                        <?php else: ?>
                                            <?php echo app('translator')->get('N/A'); ?>
                                        <?php endif; ?>
                                    </span>
                                    <br>
                                    <?php if($courierInfo->receiver_staff_id): ?>
                                        <?php echo e(__($courierInfo->receiverStaff->fullname)); ?>

                                    <?php else: ?>
                                        <span><?php echo app('translator')->get('N/A'); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Amount Order Number'); ?>">
                                    <span class="font-weight-bold"><?php echo e(getAmount($courierInfo->paymentInfo->amount)); ?> <?php echo e($general->cur_text); ?></span><br>
                                    <span><?php echo e(__($courierInfo->code)); ?></span>
                                </td>

                                 <td data-label="<?php echo app('translator')->get('Creations Date'); ?>">
                                    <?php echo e(showDateTime($courierInfo->created_at, 'd M Y')); ?>

                                </td>

                                <td data-label="<?php echo app('translator')->get('Payment Status'); ?>">
                                    <?php if($courierInfo->paymentInfo->status == 1): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Paid'); ?></span>
                                    <?php elseif($courierInfo->paymentInfo->status == 0): ?>
                                        <span class="badge badge--danger"><?php echo app('translator')->get('Unpaid'); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($courierInfo->status == 0): ?>
                                        <span class="badge badge--primary"><?php echo app('translator')->get('Received'); ?></span>
                                    <?php elseif($courierInfo->status == 1): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Delivery'); ?></span>
                                    <?php endif; ?>
                                </td>
                            
                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                   <a href="<?php echo e(route('staff.courier.invoice', encrypt($courierInfo->id))); ?>" title="" class="icon-btn bg--10 ml-1"><?php echo app('translator')->get('Invoice'); ?></a>
                                   <a href="<?php echo e(route('staff.courier.details', encrypt($courierInfo->id))); ?>" title="" class="icon-btn btn--priamry ml-1"><?php echo app('translator')->get('Details'); ?></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($courierLists)); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('breadcrumb-plugins'); ?>
    <form action="<?php echo e(route('staff.courier.search')); ?>" method="GET" class="form-inline float-sm-right bg--white mb-2 ml-0 ml-xl-2 ml-lg-0">
        <div class="input-group has_append  ">
            <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Order Number'); ?>" value="<?php echo e($search ?? ''); ?>">
            <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>

    <form action="<?php echo e(route('staff.courier.date.search')); ?>" method="GET" class="form-inline float-sm-right bg--white">
        <div class="input-group has_append ">
            <input name="date" type="text" data-range="true" data-multiple-dates-separator=" - " data-language="en" class="datepicker-here form-control" data-position='bottom right' placeholder="<?php echo app('translator')->get('Min date - Max date'); ?>" autocomplete="off" value="<?php echo e(@$dateSearch); ?>">
            <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>

<?php $__env->stopPush(); ?>


<?php $__env->startPush('script-lib'); ?>
  <script src="<?php echo e(asset('assets/staff/js/vendor/datepicker.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/staff/js/vendor/datepicker.en.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
  <script>
    (function($){
        "use strict";
        if(!$('.datepicker-here').val()){
            $('.datepicker-here').datepicker();
        }
    })(jQuery)
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('staff.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highogyr/public_html/core/resources/views/staff/courier/list.blade.php ENDPATH**/ ?>